<?php
if (!defined('ABSPATH')) {
	exit;
}

final class ACWPCommentProtectionAssets {
	public static function init(): void {
		add_action('wp_enqueue_scripts', [__CLASS__, 'enqueueFrontend']);
	}

	public static function enqueueFrontend(): void {
		// tylko na pojedynczych treściach i tylko gdy komentarze są otwarte.
		if (!is_singular()) {
			return;
		}

		$postId = (int) get_queried_object_id();
		if ($postId <= 0) return;

		if (!comments_open($postId)) {
			return;
		}

		// ===== CSS =====
		$cssRel = 'assets/comments.css';
		$cssPath = ACWPCommentProtectionPlugin::pluginPath($cssRel);
		if (file_exists($cssPath)) {
			wp_enqueue_style(
				'acwp-comments-style',
				ACWPCommentProtectionPlugin::pluginUrl($cssRel),
				[],
				(string) filemtime($cssPath)
			);
		}

		// ===== JS =====
		$jsRel = 'assets/comment-protection.js';
		$jsPath = ACWPCommentProtectionPlugin::pluginPath($jsRel);
		if (!file_exists($jsPath)) {
			return;
		}

		wp_enqueue_script(
			'acwp-comment-protection',
			ACWPCommentProtectionPlugin::pluginUrl($jsRel),
			[],
			(string) filemtime($jsPath),
			true
		);

		wp_localize_script('acwp-comment-protection', 'commentProtectionCfg', [
			'ajaxUrl' => admin_url('admin-ajax.php'),
			'action'  => ACWPCommentProtectionAjax::getAjaxAction(),
			'nonce'   => wp_create_nonce(ACWPCommentProtectionAjax::getNonceAction()),

			// UX.
			'defaultAuthor'   => 'Anonimowy',
			'respondSelector' => '#respond',
			'formSelector'    => '#commentform',

			// komunikaty (3 typy) + kompatybilność wsteczna.
			'message'        => 'Komentarz dodany i niedługo pojawi się na stronie', // legacy
			'successMessage' => 'Komentarz dodany i niedługo pojawi się na stronie',
			'spamMessage'    => 'Nasze systemy antyspamowe wykryły podejrzaną treść i komentarz został odrzucony.',
			'urlMessage'     => 'Nasze systemy wykryły link w komentarzu i został odrzucony.',
		]);
	}
}
