<?php
/**
 * Plugin Name: Comment Protection – Antyspam komentarzy
 * Description: Antyspam dla systemu komentarzy WordPress: blokada linków/URL, słów i domen e-mail, opcjonalny e-mail, AJAX submit i czytelne komunikaty.
 * Version: 1.0.0
 * Requires at least: 6.0
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Author: ACWP (Mateusz Turek)
 * Author URI: https://acwp.pl/
 * License: GPLv2 or later
 * Text Domain: comment-protection
 */

if (!defined('ABSPATH')) {
	exit;
}

final class ACWPCommentProtectionPlugin {
	public const VERSION = '1.0.0';
	public const TEXT_DOMAIN = 'comment-protection';

	public static function init(): void {
		// ładujemy klasy dopiero po załadowaniu WP (bez side-effectów w global scope).
		require_once __DIR__ . '/includes/class-comment-protection-core.php';
		require_once __DIR__ . '/includes/class-comment-protection-ajax.php';
		require_once __DIR__ . '/includes/class-comment-protection-assets.php';
		require_once __DIR__ . '/includes/class-comment-protection-admin.php';

		add_action('plugins_loaded', [__CLASS__, 'loadTextDomain']);

		// link „Ustawienia” na liście wtyczek (prowadzi do Ustawienia → Dyskusja i przewija do sekcji wtyczki).
		add_filter('plugin_action_links_' . plugin_basename(__FILE__), [__CLASS__, 'addActionLinks']);

		add_action('init', static function () {
			ACWPCommentProtection::init();
			ACWPCommentProtectionAjax::init();
			ACWPCommentProtectionAssets::init();
		});

		add_action('admin_init', static function () {
			ACWPCommentProtectionAdmin::init();
		});
	}

	public static function addActionLinks(array $links): array {
		// ustawienia są w „Ustawienia → Dyskusja”, a kotwica przewija do sekcji wtyczki.
		$settings_url  = admin_url('options-discussion.php#acwp-comment-protection');
		$settings_link = '<a href="' . esc_url($settings_url) . '">' . esc_html__('Ustawienia', self::TEXT_DOMAIN) . '</a>';
		array_unshift($links, $settings_link);
		return $links;
	}

	public static function loadTextDomain(): void {
		load_plugin_textdomain(
			self::TEXT_DOMAIN,
			false,
			dirname(plugin_basename(__FILE__)) . '/languages'
		);
	}

	public static function pluginUrl(string $path = ''): string {
		return plugins_url(ltrim($path, '/'), __FILE__);
	}

	public static function pluginPath(string $path = ''): string {
		return plugin_dir_path(__FILE__) . ltrim($path, '/');
	}

}

ACWPCommentProtectionPlugin::init();
