<?php
/**
 * Plugin Name: Maintenance Mode
 * Description: Włącza tryb konserwacji WordPress dla użytkowników bez dostępu (HTTP 503). Auto-wyłączenie po dacie, whitelist IP i dostęp per role.
 * Version: 1.3.0
 * Requires at least: 6.0
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Author: ACWP (Mateusz Turek)
 * Author URI: https://acwp.pl/
 * License: GPLv2 or later
 * Text Domain: maintenance-mode
 */

if (!defined('ABSPATH')) {
    exit;
}

// Opcje (stałe)
define('MAINT_MODE_OPT_ENABLED', 'maintenance_mode_enabled');
define('MAINT_MODE_OPT_TITLE', 'maintenance_mode_title');
define('MAINT_MODE_OPT_CONTENT', 'maintenance_mode_content');
define('MAINT_MODE_OPT_BG', 'maintenance_mode_background_image');

define('MAINT_MODE_OPT_UNTIL', 'maintenance_mode_until'); // datetime-local: Y-m-d\TH:i
define('MAINT_MODE_OPT_IP_WHITELIST', 'maintenance_mode_ip_whitelist');
define('MAINT_MODE_OPT_ALLOWED_ROLES', 'maintenance_mode_allowed_roles');

// Komentarz po polsku: kotwica do sekcji ustawień (jak w Export to PDF)
define('MAINT_MODE_SETTINGS_ANCHOR', 'maintenance_mode_section');

require_once __DIR__ . '/includes/access.php';
require_once __DIR__ . '/includes/render.php';
require_once __DIR__ . '/includes/settings.php';
require_once __DIR__ . '/includes/admin.php';

// Render trybu konserwacji
add_action('template_redirect', 'maintenanceModeMaybeRender');

// Ustawienia (Ustawienia → Ogólne)
add_action('admin_init', 'maintenanceModeRegisterSettings');

// Notice w kokpicie
add_action('admin_notices', 'maintenanceModeAdminNotice');

// Link „Ustawienia” w akcjach wtyczki (row-actions)
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'maintenanceModePluginActionLinks');

// Link „Ustawienia” także w meta wtyczki (linia pod opisem) – jak w Twoim Export to PDF
add_filter('plugin_row_meta', 'maintenanceModePluginRowMetaLinks', 10, 2);

/**
 * dodaje link „Ustawienia” w meta wiersza (pod opisem wtyczki).
 */
function maintenanceModePluginRowMetaLinks(array $links, string $file): array {
    if ($file !== plugin_basename(__FILE__)) {
        return $links;
    }

    $links[] = '<a href="' . esc_url(admin_url('options-general.php#' . MAINT_MODE_SETTINGS_ANCHOR)) . '">' . esc_html__('Ustawienia', 'maintenance-mode') . '</a>';
    return $links;
}