<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Komentarz po polsku: renderujemy własną stronę maintenance (bez wp_die),
 * bo wp_die ma własny layout i potrafi psuć wygląd.
 */
function maintenanceModeMaybeRender(): void {
    maintenanceModeMaybeAutoDisable();

    if (!get_option(MAINT_MODE_OPT_ENABLED, false)) {
        return;
    }

    // Whitelist IP ma priorytet – zawsze wpuszcza
    $clientIp = maintenanceModeGetClientIp();
    $rawWhitelist = (string) get_option(MAINT_MODE_OPT_IP_WHITELIST, '');
    if ($rawWhitelist !== '' && maintenanceModeIpInWhitelist($clientIp, $rawWhitelist)) {
        return;
    }

    // Dostęp dla ról (np. admin + editor)
    if (maintenanceModeUserHasRoleAccess()) {
        return;
    }

    $defaultMessage = 'Przepraszamy, nasza strona jest obecnie w trakcie konserwacji. Proszę spróbować ponownie później.';
    $contentRaw = (string) get_option(MAINT_MODE_OPT_CONTENT, $defaultMessage);
    $contentRaw = trim($contentRaw) !== '' ? $contentRaw : $defaultMessage;
    $content = wp_kses_post($contentRaw);

    $title = (string) get_option(MAINT_MODE_OPT_TITLE, 'Tryb konserwacji');
    $title = trim($title) !== '' ? $title : 'Tryb konserwacji';

    $bg = esc_url((string) get_option(MAINT_MODE_OPT_BG, ''));

    // SEO + cache
    nocache_headers();
    status_header(503);
    header('Content-Type: text/html; charset=' . get_bloginfo('charset'));
    header('Retry-After: 3600');

    echo '<!doctype html>';
    echo '<html ' . get_language_attributes() . '>';
    echo '<head>';
    echo '<meta charset="' . esc_attr(get_bloginfo('charset')) . '">';
    echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
    echo '<title>' . esc_html($title) . '</title>';
    echo '<style>';
    echo 'html,body{height:100%;}';
    echo 'body{margin:0;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Arial,sans-serif;}';
    echo '.maintenance-wrap{'
        . 'width:100%;height:100vh;display:flex;justify-content:center;align-items:center;'
        . 'position:fixed;top:0;left:0;'
        . ($bg ? 'background-image:url(' . $bg . ');background-size:cover;background-position:center;background-repeat:no-repeat;' : 'background:#f5f5f5;')
        . '}';
    echo '.maintenance-box{padding:20px;background:rgba(255,255,255,0.8);max-width:900px;width:calc(100% - 40px);box-sizing:border-box;}';
    echo '</style>';
    echo '</head>';
    echo '<body>';
    echo '<div class="maintenance-wrap"><div class="maintenance-box">' . wpautop($content) . '</div></div>';
    echo '</body></html>';

    exit;
}