<?php
if (!defined('ABSPATH')) {
    exit;
}

function maintenanceModeAdminNotice(): void {
    if (get_option(MAINT_MODE_OPT_ENABLED, false)) {
        $url = admin_url('options-general.php');
        echo '<div class="notice notice-warning">';
        echo '<p><strong>Tryb konserwacji jest aktywny.</strong> <a href="' . esc_url($url) . '">Przejdź do ustawień</a></p>';
        echo '</div>';
    }
}

function maintenanceModePluginActionLinks(array $links): array {
    $settings = '<a href="' . esc_url(admin_url('options-general.php#maintenance_mode_section')) . '">' . esc_html__('Ustawienia', 'maintenance-mode') . '</a>';
    array_unshift($links, $settings);
    return $links;
}
